#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ******** MPR 2 Band Notch *******

Function MPR2BandNotchReset()
	MPR2BandNotchSetupDesign()
	SetAxis/A/Z bottom			// in case user set a manual X axis range
	Execute "MPRBandNotchCompute(\"\")"
End

Function ButtonMPR2BandNotch(ctrlName) : ButtonControl
	String ctrlName

	DoWindow/F WMMPR2BandNotchDesign
	if( V_Flag==0 )
		MPR2BandNotchSetupDesign()
	endif
End

Function MPR2BandNotchSetupDesign()

	SetApplyButtonTitle(0)

	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	Variable lphp=NumVarOrDefault("m2bn_lphp",1)
	Variable nt=NumVarOrDefault("m2bn_n",41)
	Variable b1end=NumVarOrDefault("m2bn_b1e",0.25)
	Variable b2start=NumVarOrDefault("m2bn_b2s",0.35)
	Variable b1weight=NumVarOrDefault("m2bn_b1w",1)
	Variable fNotch=NumVarOrDefault("m2bn_fn",0.4)
	Variable sharp=NumVarOrDefault("m2bn_shp",0.5)

	// Create the globals
	Variable/G m2bn_lphp=lphp
	Variable/G m2bn_n=nt
	Variable/G m2bn_b1e=b1end
	Variable/G m2bn_b2s=b2start
	Variable/G m2bn_b1w=b1weight
	Variable/G m2bn_fn=fNotch
	Variable/G m2bn_shp=sharp

	// scale the saved normalized frequencies for the SetVariable controls
	Variable/G m2bn_b1e_fs= b1end * fs
	Variable/G m2bn_b2s_fs= b2start * fs
	Variable/G m2bn_fn_fs= fNotch * fs
	SetDataFolder dfSav

	MPR2BandNotchUpdate()
	
	CreateMPR2BandNotchDesign()
	MPR2BandNotchUpdate()			// set the control limits, too.
End

Function MPR2BandNotchUpdate()
	String dfSav= Set_IFDL_DataFolder()
	Variable fs= NumVarOrDefault("fs",1)

	Variable lphp= NumVarOrDefault("m2bn_lphp",1)
	Variable nt= NumVarOrDefault("m2bn_n",41)
	Variable b1weight= NumVarOrDefault("m2bn_b1w",1)

	Variable b1endFs= NumVarOrDefault("m2bn_b1e_fs",0.25 * fs)
	Variable b2startFs=NumVarOrDefault("m2bn_b2s_fs",0.35 * fs)

	Variable fNotchFs=NumVarOrDefault("m2bn_fn_fs",0.4 * fs)
	Variable sharp=NumVarOrDefault("m2bn_shp",0.5)

	// Save the normalized frequencies in case the user changes sampling frequency
	Variable/G m2bn_b1e= b1endFs/fs
	Variable/G m2bn_b2s= b2startFs/fs
	Variable/G m2bn_fn= fNotchFs/fs
	// keep number of terms odd
	Variable/G 	m2bn_n = nt %| 0x1

	Variable isLowPass= lphp == 1 
	
	// Passband and stop band response pair
	Make/O m2bn_responseX = {0,b1endFs,NaN,b2startFs,fs*0.5}
	Make/O m2bn_response  = {isLowPass,isLowPass,NaN,!isLowPass,!isLowPass}	// updated by DesiredFromActualResponse
	Variable eps= abs(b1EndFs - b2startFS)/8
	DesiredFromActualResponse(m2bn_response,"WMMPR2BandNotchDesign",b1endFs,b2startFs,0,0,isLowPass,eps)

	// transition region waves
	Make/O     m2bn_transitionX = {m2bn_responseX[1],m2bn_responseX[3]}
	Make/O/N=2 m2bn_transitionPlus =  max(m2bn_response[0],m2bn_response[3])
	Make/O/N=2 m2bn_transitionMinus = min(m2bn_response[0],m2bn_response[3])
	// notch  QuickDrag Waves
	Make/O m2bn_notchX={0,0}
	Make/O m2bn_notchFrequency={-inf,inf}
	
	DoWindow WMMPR2BandNotchDesign
	if( V_Flag == 1 )
 		// don't allow the end of the pass band to exceed the start of the stop band
 		ControlInfo/W=WMMPR2BandNotchDesign m2bn_b1e
		Variable band1End= V_Value
		ControlInfo/W=WMMPR2BandNotchDesign m2bn_b2s
		Variable band2Start= V_Value

		Variable df=  NiceNumber(fs/200)
		// don't let band 1 end after the start of band 2
		Variable end1Max= max(band1End,band2Start)
		end1Max= limit(end1Max,0,fs/2)
		SetVariable m2bn_b1e,limits={0,end1Max,df},win=WMMPR2BandNotchDesign
		
		// don't let band 2 start before the end of band 1
		Variable start2Min= min(band1End,band2Start)
		start2Min= limit(start2Min,0, fs/2)
		SetVariable m2bn_b2s,limits={start2Min,fs/2,df},win=WMMPR2BandNotchDesign

		// keep the frequency notch in the reject band
		NVAR frequencyNotchFS= root:Packages:WM_IFDL:m2bn_fn_fs

		if( isLowPass )
			frequencyNotchFS= limit(frequencyNotchFS,band2Start,fs/2) // force notch into second band
			SetVariable m2bn_fn,limits={start2Min,fs/2,df},win=WMMPR2BandNotchDesign
		else
			frequencyNotchFS= limit(frequencyNotchFS,0,band1End) // force notch into first band
			SetVariable m2bn_fn,limits={0,end1Max,df},win=WMMPR2BandNotchDesign
		endif
		NVAR frequencyNotch= root:Packages:WM_IFDL:m2bn_fn
		frequencyNotch= frequencyNotchFS/ fs
		ControlUpdate/A/W=WMMPR2BandNotchDesign
		CheckDisplayed/W=WMMPR2BandNotchDesign m2bn_notchFrequency
		if( V_Flag == 1 )
			ModifyGraph offset(m2bn_notchFrequency)={frequencyNotchFS,0}
		endif
		
		// keep the number of terms an odd number
	endif
	SetDataFolder dfSav
End

Function CreateMPR2BandNotchDesign()

	if( DesignGraph("WMMPR2BandNotchDesign","MPR 2 Band Notch Design") )
		return 1	// already existed, don't reset the graph settings.
	endif

	NVAR fs= root:Packages:WM_IFDL:fs
	NVAR lphp= root:Packages:WM_IFDL:m2bn_lphp	// see PopupMenu m2bn_lphp, below
	String typeList= "low pass [NOTCH IN SECOND BAND];high pass [NOTCH IN First BAND]"
	String popMenuValue= GetStrFromList(typeList, lphp, ";")
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls

	String dfSav= Set_IFDL_DataFolder()
	AppendToGraph/L=responseLeft m2bn_transitionPlus,m2bn_transitionMinus vs m2bn_transitionX
	AppendToGraph/L=responseLeft m2bn_response vs m2bn_responseX
	AppendToGraph/L=responseLeft m2bn_notchFrequency vs m2bn_notchX
	SetDataFolder dfSav

	ModifyGraph margin(left)=67
	ModifyGraph mode(m2bn_transitionPlus)=7
	ModifyGraph lSize(m2bn_transitionPlus)=0,lSize(m2bn_transitionMinus)=0
	ModifyGraph rgb(m2bn_transitionPlus)=(56797,56797,56797)
	ModifyGraph hbFill(m2bn_transitionPlus)=2
	ModifyGraph toMode(m2bn_transitionPlus)=1
	ModifyGraph minor(bottom)=1
	ModifyGraph lblPos(responseLeft)=60
	ModifyGraph freePos(responseLeft)={0,bottom}

	// QuickDrag wave
	ModifyGraph quickdrag(m2bn_notchFrequency)=1,live(m2bn_notchFrequency)=1
	ModifyGraph lSize(m2bn_notchFrequency)=2 //,mode(m2bn_notchFrequency)=1
	ModifyGraph rgb(m2bn_notchFrequency)=(36873,14755,58982)
	QuickDragForWindowSetup("WMMPR2BandNotchDesign","MPR2BandNotchQuickDrag",0)
	String/G root:WinGlobals:MPR2BandNotchQuickDrag:S_TraceOffsetInfo= ""

	SetAxis/A/N=1 responseLeft
	Label responseLeft "response (dB)"
	ControlBar 85
	SetVariable m2bn_b1e,pos={32,4},size={207,17},proc=MPR_m2bNotch,title="End of First Band"
	SetVariable m2bn_b1e,limits={0,250,5},value= root:Packages:WM_IFDL:m2bn_b1e_fs
	SetVariable m2bn_b2s,pos={8,22},size={231,17},proc=MPR_m2bNotch,title="Start of Second Band"
	SetVariable m2bn_b2s,limits={200,500,5},value= root:Packages:WM_IFDL:m2bn_b2s_fs
	PopupMenu m2bn_lphp,pos={4,41},size={318,19},proc=MPR2BandNotchTypePopup,title="Filter Type"
	PopupMenu m2bn_lphp,mode=lphp,popvalue=popMenuValue,value= #"\"low pass [NOTCH IN SECOND BAND];high pass [NOTCH IN First BAND]\""
	SetVariable m2bn_b1w,pos={298,4},size={184,17},title="First Band Weighting"
	SetVariable m2bn_b1w,limits={0.001,Inf,0.5},value= root:Packages:WM_IFDL:m2bn_b1w
	SetVariable m2bn_n,pos={322,22},size={160,17},proc=MPR_m2bNotch,title="Number of Terms"
	SetVariable m2bn_n,limits={5,9999,2},value= root:Packages:WM_IFDL:m2bn_n
	CheckBox dbCheck,pos={250,64},size={110,15},proc=MPR2BandNotchCheck,title="dB Response",value=1
	Button m2bnCompute,pos={365,63},size={109,20},proc=MPRBandNotchCompute,title="Compute Filter"
	SetVariable m2bn_sharp,pos={326,42},size={156,17},proc=MPR_m2bNotch,title="Notch Sharpness"
	SetVariable m2bn_sharp,limits={0,Inf,0.5},value= root:Packages:WM_IFDL:m2bn_shp
	SetVariable m2bn_fn,pos={37,63},size={202,17},proc=MPR_m2bNotch,title="Notch Frequency"
	SetVariable m2bn_fn,limits={200,500,5},value= root:Packages:WM_IFDL:m2bn_fn_fs
	Textbox/N=m2bnLegend/X=0.99/Y=34.30 ""
	m2bnLegend()
	SetWindow WMMPR2BandNotchDesign,hook=m2bnDesignHook
	return 0
End

Function m2bnDesignHook(infoStr)
	String infoStr

	designHook(infoStr)
	Variable statusCode= 0
	String event= StrByKey("EVENT",infoStr)
	if( CmpStr(event,"kill") == 0 )
		statusCode= 1
		QuickDragForWindowSetup("WMMPR2BandNotchDesign","MPR2BandNotchQuickDrag",1)	// kill
	endif
	return statusCode
end

// Fires on a dependency. str is S_TraceOffsetInfo from the quickdrag stuff
//
// after a [quickdrag] trace is dragged, Igor will store information in the string using the
// following key-value format:
// GRAPH:<name of graph>;XOFFSET:<x offset value>;YOFFSET:<y offset value>;TNAME:<trace name>;

Function MPR2BandNotchQuickDrag(str)
	String str	// value of root:WinGlobals:WMMPR2BandNotchDesign:S_TraceOffsetInfo= ""

	String graphName= StrByKey("GRAPH",str)
	if( strlen(graphName) < 1 )
		return 0
	endif
	DoWindow $graphName
	if( V_Flag != 1 )
		return 0 // not valid
	endif
	if(CmpStr(StrByKey("TNAME",str),"m2bn_notchFrequency") != 0 )
		return 0								// not valid yet
	endif
	Variable frequencyNotchFS= NumByKey("XOFFSET",str)

	NVAR fs= root:Packages:WM_IFDL:fs
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls

	String dfSav= Set_IFDL_DataFolder()
	Variable b1endFs= NumVarOrDefault("m2bn_b1e_fs",0.25 * fs)
	Variable b2startFs=NumVarOrDefault("m2bn_b2s_fs",0.35 * fs)
	Variable isLowPass= NumVarOrDefault("m2bn_lphp",1) == 1
	SetDataFolder dfSav

	if( isLowPass )
		frequencyNotchFS= limit(frequencyNotchFS,b2startFs,fs/2-df) // limit notch into second band
	else
		frequencyNotchFS= limit(frequencyNotchFS,0+df,b1endFs) // force notch into first band
	endif
	NVAR fns= root:Packages:WM_IFDL:m2bn_fn_fs
	fns= frequencyNotchFS
	NVAR frequencyNotch= root:Packages:WM_IFDL:m2bn_fn
	frequencyNotch= frequencyNotchFS/ fs
	ControlUpdate/W=WMMPR2BandNotchDesign m2bn_fn
	
	WAVE notchWave= root:Packages:WM_IFDL:m2bn_notchFrequency
	CheckDisplayed/W=$graphName notchWave
	if( V_Flag %& (CmpStr(graphName,WinName(0,1))==0) )	// only if this graph is topmost
		ModifyGraph offset(m2bn_notchFrequency)={frequencyNotchFS,0}	// remove y offset
	endif
	return 0 
End

Function MPR2BandNotchTypePopup(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum
	String popStr

	NVAR lphp= root:Packages:WM_IFDL:m2bn_lphp
	lphp= popNum
	MPR2BandNotchUpdate()
End

Function MPR2BandNotchCheck(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
 	
 	dBCheck(checked)
	MPR2BandNotchUpdate()
	m2bnLegend()
End

Function MPR_m2bNotch(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	
	MPR2BandNotchUpdate()
End

Function m2bnLegend()
	DesignLegend("WMMPR2BandNotchDesign","m2bn","m2bnLegend")
End

Proc MPRBandNotchCompute(ctrlName) : ButtonControl
	String ctrlName

	Silent 1;PauseUpdate
	String dfSav= Set_IFDL_DataFolder()

	Variable lphp= m2bn_lphp
	Variable b1end= m2bn_b1e
	Variable b2start= m2bn_b2s
	Variable fNotch=m2bn_fn
	Variable sharp=m2bn_shp
	Variable b1weight= m2bn_b1w
	Variable nt= m2bn_n

	Variable islp= lphp == 1
	SetDataFolder dfSav

	if( nt > 9999 )
		Abort "Too many filter terms. Max is 9999."
	endif 

	if( ChkFreq(b1end,b2start,fNotch,0) )
		abort
	endif
		
	if(islp)
		if(fNotch<b2start)
			abort "Notch must be in second band."
		endif
	else
		if((fNotch<0)+(fNotch>b1end))
			abort "Notch must be in first band."
		endif
	endif

	String mpDes="des"		// names of 3 waves to create in WM_IFDL data folder
	String mpWt="wt"
	String mpGrid="grid"
	MPRMakeWaves(mpDes,mpWt,mpGrid,nt)

	Set_IFDL_DataFolder()
	String/G proposedFilterName="mpr2BandNotch"
	String/G designTypeName="McClellan-Parks; two band with notch"
	Variable/G designFlags=0x3
	Make/O bandInfo={islp,0,b1end*fs,!islp,b2start*fs,0.5*fs}

	$mpWt=abs(sharp*(cos(2*pi*x)-cos(2*pi*fNotch)))
	$mpDes=1/$mpWt
	$mpDes(0,b1end) *=  islp
	$mpDes(b2start,) *= islp==0
	$mpWt(0,b1end) *= b1weight
	$mpGrid(b1end,b2start)=NaN
	if(1)	//  Note: use 0 for equi-ripple stopband; 1 for less ripple in passband.
		if(islp)
			$mpWt(b2start,)=1
		else
			$mpWt(0,b1end)=b1weight
		endif
	endif
	
	SetDataFolder dfSav
	Make/O/N=(nt) coefs		// created in the user's data folder (the current data folder)
	
	MPKernel(mpDes,mpWt,mpGrid,"coefs",0)
	
	// Note: To implement this filter as a cascade of 2 filters, see documentation
	if(1)
		Set_IFDL_DataFolder()
		if( islp )
			Make/O H2_tmp = {0.5*sharp,-sharp*cos(2*pi*fNotch),0.5*sharp}
		else
			Make/O H2_tmp = {-0.5*sharp,sharp*cos(2*pi*fNotch),-0.5*sharp}
		endif
		Convolve H2_tmp, $(dfSav+"coefs")
		KillWaves H2_tmp
		SetDataFolder dfSav
	endif
	
	StdCoefsTreatmentNoShowResults(0x1e,1)

	DoWindow/F WMMPR2BandNotchDesign
	CheckDisplayed/W=WMMPR2BandNotchDesign root:Packages:WM_IFDL:coefsMag,root:Packages:WM_IFDL:coefsDbMag
	if( V_Flag == 0 )
		ControlInfo/W=WMMPR2BandNotchDesign dbCheck
		Variable wantDB= V_value
		Append/L=responseLeft $responseName(wantDB,1)
		String traceName= responseName(wantDB,0)
		ModifyGraph rgb($traceName)=(0,0,65535)
		ReorderTraces m2bn_response, {$traceName}
	endif
	AppendPassDetails("detailsLeft",root:Packages:WM_IFDL:magPassDetails)	// appends /L=detailsLeft
	MPR2BandNotchUpdate()
	AutoApplyFilter()
	m2bnLegend()
End

